/*------------------------------------------------------------------------------*
 * File Name: LabTalkAccessEx.c													*
 * Creation: BT & GJL 8/13/03													*
 * Purpose: OriginC Source C file containing LabTalkAccessEx examples.			*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009	*
 * All Rights Reserved															*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>

// Get the value of a numeric LabTalk object property 
void GetNumericVariable( )
{
	double vv; // Get Layer.ShowX property value 
	LT_get_var("LAYER.SHOWX", &vv);
	printf("The value is: %.1f\n", vv);
}

// Get and Set the value of a LabTalk numeric variable 
void GetAndSetNumericVariable()
{
	double dIn, dNew;
	if( LT_get_var("X1", &dIn) ) // Get X1 variable
	{
		dNew = dIn - 10;
		LT_set_var("X1", dNew); // Set X1 variable
		printf("The initial X1 scale value of %g was changed to %g\n", dIn, dNew);
	}
}

// Get the value of a LabTalk string variable 
void GetActiveDatasetName()
{
	char szTemp[100];
	LT_get_str("%C", szTemp, 100); // Get %C variable
	string strC = szTemp;
	printf("The active data set is:  %s\n", strC);
}

// Evaluate a LabTalk expression
void EvaluateExpression()
{
	double vv;
	LT_evaluate("sin(PI/2)", &vv); // Evaluate sin(PI/2) (==1)
	printf("vv = %f\n", vv);
}

// Execute LabTalk statements
void ExecuteStatements()
{
	// Make list of all worksheet windows in current project
	LT_execute("%Z="";doc -e W {%Z=%Z %H};type -a %Z");

	// Run section of LabTalk script
	LT_execute("run.section(File.OGS, Open)");
}

// Execute a LabTalk statement with Data1 page temporarily active
void ExecuteStatementWithPageActive()
{
	Page pg("Data1");
	pg.LT_execute("type -b %H is temporarily set to active page.");

	LT_execute("type -b Even though %H is currently the active page.");
}

// Execute section of Labtalk script below
void ExecuteSectionInCFile()
{
	LT_execute("run.section(Samples\Programming\Origin C Files\LabTalkAccessEx.c, Main)");
}

#ifdef LABTALK // can be anything not defined
[Main]
type -b "Currently executing a section of LabTalk script
in the source file LabTalkAccessEx.c";
#endif

// Execute an _LT_Obj block mixing Origin C statements
// with LabTalk sort object properties and methods  
void ExecuteLTObjBlock()
{
	string strWinName = "Data1";
	_LT_Obj
	{
		string strDsName = "Data1_A";
		Dataset dsData1A(strDsName);
		if( dsData1A.IsValid() )
		{
			int iSize = dsData1A.GetSize();
			sort.wksname$ = strWinName;
			sort.c1 = 1; // Sort only first 2 cols
			sort.c2 = 2;
			sort.r1 = 1; 
			sort.r2 = iSize;
			sort.cname1$ = "A: A"; 		
			sort.wks();
		}
	}
}

// Execute a mix of Origin C statements and LabTalk sort object
// properties and methods using the "LabTalk" and "using" keywords  
void ExecuteUsingLabTalkDot()
{
	using sort = LabTalk.sort;

	string strWinName = "Data1";
	string strDsName = "Data1_A";
	Dataset dsData1A(strDsName);
	if( dsData1A.IsValid() )
	{
		int iSize = dsData1A.GetSize();
		sort.wksname$ = strWinName;
		sort.c1 = 1; // Sort only first 2 cols
		sort.c2 = 2;
		sort.r1 = 1; 
		sort.r2 = iSize;
		sort.cname1$ = "D: A"; 		
		sort.wks();
	}
}